#!/bin/bash
#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# Bash Script:   Install-Proffast-Linux.py
# Version/Date:  V01 (20.10.2020)
# Project:       COCCON-PROCEEDS, FRM4GHG, and S5P-MPC funded by ESA
# Created by:    Friedrich Klappenbach, Technical University of Munich (TUM), ge79wul@mytum.de 
#-------------------------------------------------------------------------------------------------#
# This script installs the prf96 proffast retrieval code under Linux.
# It downloads the source, unzipps it and copies it into the according locations.
# Finally it compiles the required Linux-programs.
# Requirements:
# 	wget 
# 	Internet access
# 	unzip
# 	fortran compiler (e.g. fortran-8)
# if not available use:
# 	apt-get update
# 	apt-get upgrade
# 	apt-get install wget
# 	apt-get install unzip
# 	apt-get install gfortran
#-------------------------------------------------------------------------------------------------#
# Date:  2020/10/20
# Coder: Klappenbach, Friedrich <ge79wul@mytum.de> 
#-------------------------------------------------------------------------------------------------#
#=================================================================================================#


#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# choose a folder to install Subfolder prf96-EM27-fast will created here
INSTALL_FOLDER='/home/esm/TEST/' # ! Absolute Path !

VERSION='2020-08-10' 	         # Version of the entire package
VERSION_PREPROCESS='2020-06-12'  # Version of the preprocess software to compile
VERSION_INVERSE='2020-08-10' 	 # Version of the inverse software to compile
VERSION_PCX='2020-07-15' 	     # Version of the pcx software to compile

COMPILER='gfortran-8'	         # Fortran Compiler see availabe compilers with dpkg --list | grep compiler

## END of USERINPUT

#-------------------------------------------------------------------------------------------------#

# 0. create install folder:
mkdir -p ${INSTALL_FOLDER}

# 1. download the files from https:
cd ${INSTALL_FOLDER}
wget https://www.imk-asf.kit.edu/downloads/Coccon-SW/${VERSION}_prf96-EM27-fast.zip

# 2. unzip the files into
cd ${INSTALL_FOLDER}

unzip ${VERSION}_prf96-EM27-fast.zip 
mkdir ./prf96-EM27-fast 
mv ${VERSION}_prf96-EM27-fast/* ${INSTALL_FOLDER}/prf96-EM27-fast/

# cleanup:
rm -r ${VERSION}_prf96-EM27-fast
rm ${VERSION}_prf96-EM27-fast.zip 

#-------------------------------------------------------------------------------------------------#

# Compile the sourcecode:
echo 'compiling preprocess...'
cd ${INSTALL_FOLDER}/prf96-EM27-fast/source/${VERSION_PREPROCESS}_sources-preprocess_Linux
${COMPILER} -O2 -o ../../preprocess/preprocess4 glob_prepro4.F90 glob_OPUSparms.F90 preprocess4.F90
echo 'done.'

echo 'compiling inverse10...'
cd ${INSTALL_FOLDER}/prf96-EM27-fast/source/${VERSION_INVERSE}_source-invers10_Linux
${COMPILER} -O2 -o ../../invers10 globinv10.f90 invers10.f90
echo 'done.'

echo 'compiling pcx...'
cd ${INSTALL_FOLDER}/prf96-EM27-fast/source/${VERSION_PCX}_source-pcxs10_Linux 
${COMPILER} -O2 -o ../../pcxs10 globvar10.f90 globlin10.f90 globlev10.f90 pcxs10.f90
echo 'done.'

#-------------------------------------------------------------------------------------------------#
#=================================================================================================#