#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
#
#-------------------------------------------------------------------------------------------------#
#=================================================================================================#


#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# import modules/packages

import os
import re
from dateutil import parser

#-------------------------------------------------------------------------------------------------#
#=================================================================================================#


#=================================================================================================#
#-------------------------------------------------------------------------------------------------#

# path for aws files
aws_path = r'D:\cygwin64\home\prf96-EM27-fast\extra-files\log-files_sod2017_em27sn039\aws_files'

# path for output files
out_path = r'D:\cygwin64\home\prf96-EM27-fast\extra-files\log-files_sod2017_em27sn039'

# list of aws files, e.g. ["aws_20170608.lst","aws_20170609.lst"]
aws_files = os.listdir(aws_path)

#-------------------------------------------------------------------------------------------------#
# Sodankyla

# site coordinates
em27_lat = 67.36600
em27_lon = 26.63000
em27_alt = 181.0000

# TCCON solar tracker at 188.473m, AWS station at 181.843m
# EM27/SUN at 180.8m (approx. 1m lower than the AWS station)
# p_EM27 = p_AWS + 0.1mbar (0.8mbar/6.63m)
em27_pre = 0.12

#-------------------------------------------------------------------------------------------------#

line = []

aws_str = []
aws_lines = []
aws_header = []
out_header = []

#-------------------------------------------------------------------------------------------------#

print ("")
print ("================================================================================")
print ("--------------------------------------------------------------------------------")
print ("aws_path: ",aws_path)
print ("out_path: ",out_path)
print ("--------------------------------------------------------------------------------")
print ("Output files:\n")

#-------------------------------------------------------------------------------------------------#
#=================================================================================================#


#=================================================================================================#
#-------------------------------------------------------------------------------------------------#

for aws_file in aws_files:

    # read lines of the aws file into an array of strings
    file = open(os.path.join(aws_path,aws_file))
    aws_lines = file.read().split('\n')
    file.close()

    # get parameters from header line, remove space characters
    aws_header = re.sub(' +', ' ', aws_lines[1])

    # remove first 3 lines (header part)
    aws_lines = aws_lines[3:]

    # remove empty tail
    while len(aws_lines[-1]) == 0:
        aws_lines = aws_lines[:-1]

    # line number of each aws file
    n_lines = len(aws_lines)

    # remove space characters
    for i in range(n_lines):
        aws_lines[i] = re.sub(' +', ' ', aws_lines[i])
      # print (aws_lines[i])

#-------------------------------------------------------------------------------------------------#
# create aws_pt file for EM27/SUN using the datalogger format

    pt_log = aws_file[4:8] + '-' + aws_file[8:10] + '-' + aws_file[10:12] + '_00-00-00.dat'

    header_log = ['UTCdate_____\t', 'UTCtime___\t', 'UTCsec____\t', 'FreeSpaceOnDriveC\t', 'FreeSpaceOnDriveD\t',\
    'ThermoTHB40\t', 'HygroTHB40\t', 'BaroTHB40\t', 'GPSLong\t', 'GPSLat\t', 'GPSAlt\t', 'GPSTDiff\t', 'GPShdop\n']

    pt_out_log = open(os.path.join(out_path,pt_log),'w')
    pt_out_log.writelines(header_log)

    for i in range(n_lines):
        line = aws_lines[i].split(' ')
        m = []
        m.append('\"'+line[0][8:10]+'.'+line[0][5:7]+'.'+line[0][0:4]+'\"\t')            # UTCdate_____
        m.append('\"'+line[1][0:2]+':'+line[1][3:5]+':00\"\t')                           # UTCtime___
        m.append('1111111111\t')                                                         # UTCsec____
        m.append('1.1111e+11\t+1.1111e+11\t')                                            # FreeSpaceOnDriveC, FreeSpaceOnDriveD
        m.append('{:+10.4e}\t'.format(float(line[3])))                                   # ThermoTHB40
        m.append('-3.4028e+38\t')                                                        # HygroTHB40
        m.append('{:+10.4e}\t'.format(float(line[2])+em27_pre))                          # BaroTHB40
        m.append('{:+10.4e}\t{:+10.4e}\t{:+10.4e}\t'.format(em27_lon,em27_lat,em27_alt)) # GPSLong, GPSLat, GPSAlt
        m.append('-3.4028e+38\t-3.4028e+38\n')                                           # GPSTDiff, GPShdop
        pt_out_log.writelines(m)       

    pt_out_log.close()

    print (pt_log)

#-------------------------------------------------------------------------------------------------#

print ("--------------------------------------------------------------------------------")
print ("================================================================================")

#-------------------------------------------------------------------------------------------------#
#=================================================================================================#
