# -*- coding: utf-8 -*-
#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# Python script: 04_pcx-inv-parallel-processing.py
# Version/Date:  V01 (01.04.2020)
# Project:       COCCON-PROCEEDS, funded by ESA
# Created by:    Qiansi TU, Karlsruhe Institute of Technology (KIT), Germany
# Modified by:   Darko Dubravica, Karlsruhe Institute of Technology (KIT), Germany
# Description:   Parallel Processing of pcxs10.exe and invers10.exe
#-------------------------------------------------------------------------------------------------#
#=================================================================================================#


#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# import modules/packages

import os         # operating system
import time       # time
import subprocess # ...

#-------------------------------------------------------------------------------------------------#
#=================================================================================================#


#=================================================================================================#
#-------------------------------------------------------------------------------------------------#

main_path = r'.'
ana_path = r'./analysis/sod2017_em27sn039'

#-------------------------------------------------------------------------------------------------#
#=================================================================================================#


#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# input parallel processing

print ("")
print ("================================================================================")
print ("--------------------------------------------------------------------------------")

input_1 = input("Parallel processing? Yes (Y) or No (N) ... ")

if input_1 == "Y":
    input_2 = input("Number of parallel jobs (1-8) ... ")
    if input_2 not in ["1","2","3","4","5","6","7","8"]:
        print ("Wrong input ! Number of parallal jobs set to 1 !!!")
        input_2 = "1"
else:
    input_2 = 1

#-------------------------------------------------------------------------------------------------#
print ("--------------------------------------------------------------------------------")

jobs = int(input_2)

print ("Number of parallel jobs: ", jobs)

#-------------------------------------------------------------------------------------------------#
print ("--------------------------------------------------------------------------------")

date_list = os.listdir(ana_path)

print ("jobs: ", date_list)

date_list_job = []

for job_n in range(jobs):
    date_list_job.append(date_list[job_n::jobs])
    print ("job{}: ".format(job_n), date_list_job[job_n])

print ("--------------------------------------------------------------------------------")
print ("================================================================================")

#-------------------------------------------------------------------------------------------------#

for job_n in range(jobs):
    subprocess.Popen(["xterm", "-e", "python","04_pcx-inv-input-files-and-process.py", str(jobs), str(job_n)], shell = True, cwd = main_path)
    time.sleep (5) # sleep 5 seconds

#-------------------------------------------------------------------------------------------------#
#=================================================================================================#
