# -*- coding: utf-8 -*-
#==================================================================================================================#
#------------------------------------------------------------------------------------------------------------------#
# Python Script: CocconClass.py
# Version/Date:  V01 (01.10.2020)
# Project:       COCCON-PROCEEDS, FRM4GHG, and S5P-MPC funded by ESA 
# Created by:    Mahesh Kumar Sha & Bavo Langerock, Royal Belgian Institute for Space Aeronomy (BIRA-IASB), Belgium
# Modified by:   Darko Dubravica, Karlsruhe Institute of Technology (KIT), Germany
# Description:   Converts CSV format to HDF format
#------------------------------------------------------------------------------------------------------------------#
#==================================================================================================================#


#==================================================================================================================#
#------------------------------------------------------------------------------------------------------------------#
# import modules/packages

import os, h5py, time, shutil, glob, math, re
import numpy as np
import datetime as dt
import nested_dict as nd

#------------------------------------------------------------------------------------------------------------------#
#==================================================================================================================#


#==================================================================================================================#
#------------------------------------------------------------------------------------------------------------------#
# a dict with a attrs attribute

class dataDict(dict):

  def __init__(self,arg={},attrs=None,**kargs):
    if hasattr(arg,'attrs'): self.attrs=arg.attrs.copy()
    if isinstance(attrs,dict): self.attrs=attrs.copy()
    dict.__init__(self,arg,**kargs)
  def copy(self):
    return self.__class__(self)

#------------------------------------------------------------------------------------------------------------------#
#==================================================================================================================#
