# -*- coding: utf-8 -*-
# !/usr/bin/python3
#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# Python Script: 04_pcx-inv-parallel-processing.py
# Version/Date:  V01 (01.11.2020)
# Project:       COCCON-PROCEEDS, funded by ESA
# Created by:    Qiansi Tu, Karlsruhe Institute of Technology (KIT), Germany
# Modified by:   Darko Dubravica, Karlsruhe Institute of Technology (KIT), Germany
# Description:   Parallel Processing of pcxs10.exe and invers10.exe
# Comments:      See also the Python script ReadInputFile.py and
#                the input file General-Input-File.inp in the auxil directory!
#-------------------------------------------------------------------------------------------------#
#=================================================================================================#


#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# import modules/packages

import os         # operating system
import time       # time
import subprocess # ...
from auxil.ReadInputFile import *

#-------------------------------------------------------------------------------------------------#
#=================================================================================================#


#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# paths to the preprocessed data, to the analysis directory, to the map files, ...

vars = getInputVariables()
root_path = vars['root_path']
main_path = root_path

ana_path = os.path.join(root_path, 'analysis', vars['site']) # analysis directory

#-------------------------------------------------------------------------------------------------#
#=================================================================================================#


#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# start script

print ("")
print ("================================================================================")
print ("--------------------------------------------------------------------------------")

print ("main path:", main_path)
print ("ana  path:", ana_path)

#-------------------------------------------------------------------------------------------------#
# input parallel processing

print ("--------------------------------------------------------------------------------")

input_1 = input("Parallel processing? Yes (Y) or No (N) ... ")

if input_1 == "Y":
    input_2 = input("Number of parallel jobs (1-8) ... ")
    if input_2 not in ["1","2","3","4","5","6","7","8"]:
        print ("Wrong input ! Number of parallal jobs set to 1 !!!")
        input_2 = "1"
else:
    input_2 = 1

#-------------------------------------------------------------------------------------------------#
print ("--------------------------------------------------------------------------------")

jobs = int(input_2)

print ("Number of parallel jobs: ", jobs)

#-------------------------------------------------------------------------------------------------#
print ("--------------------------------------------------------------------------------")

date_list = os.listdir(ana_path)

print ("jobs: ", date_list)

date_list_job = []

for job_n in range(jobs):
    date_list_job.append(date_list[job_n::jobs])
    print ("job{}: ".format(job_n), date_list_job[job_n])

print ("--------------------------------------------------------------------------------")
print ("================================================================================")

#-------------------------------------------------------------------------------------------------#

ps = []

for job_n in range(jobs):
    pyth_cmd = os.path.join("python37 04_pcx-inv-input-files-and-process.py {} {}".format(str(jobs), str(job_n)))
  # pyth_cmd = os.path.join("python37 04_pcx-inv-input-files-and-process.py {} {} > outputA{}.txt".format(str(jobs), str(job_n), job_n))
    print (pyth_cmd)
    p = subprocess.Popen(["start", "/wait", "python37", "04_pcx-inv-input-files-and-process.py", str(jobs), str(job_n)], shell = True, cwd = main_path)
  # p = subprocess.Popen(["xterm", "-e", "cmd", "/c", pyth_cmd], shell = True, cwd = prep_path)
  # p = subprocess.Popen(["start", "/wait", pyth_cmd], shell = True, cwd = main_path)
  # time.sleep (5) # sleep 5 seconds

    ps.append(p)

for p in ps:
    p.wait()

print ("--------------------------------------------------------------------------------")
print ("PROCESSING finished!")
print ("--------------------------------------------------------------------------------")
print ("================================================================================")

#-------------------------------------------------------------------------------------------------#
#=================================================================================================#