SCREEN 12

eindatei$ = "bin-viewer1.inp"
maxspec% = 5000
DIM specname$(0 TO maxspec% - 1)

' read input file
OPEN eindatei$ FOR INPUT AS #1
CALL gonext(1)
LINE INPUT #1, inputpfad$
LINE INPUT #1, speckind$
speckind$ = speckind$ + "."
CALL gonext(1)
nspec% = 0
DO WHILE NOT EOF(1)
    zeile$ = ""
    LINE INPUT #1, zeile$
    position% = INSTR(zeile$, speckind$)
    IF position% > 0 THEN
        specname$(nspec%) = zeile$
        nspec% = nspec% + 1
        PRINT zeile$
    END IF
    IF nspec% > maxspec% OR zeile$ = "***" THEN EXIT DO
LOOP
CLOSE #1

PRINT "number of spectra:", nspec%
PRINT ""
INPUT "Continue with return", dummy$

ispec% = 0
' read header
CALL readspchead(inputpfad$, specname$(ispec%), 1, datum$, UTtime!, sunelev!, sunazi!)
' read spectrum
maxnue& = 56900
DIM spec!(0 TO maxnue& - 1), specwrk!(0 TO maxnue& - 1), specmean!(0 TO maxnue& - 1), specdiff!(0 TO maxnue& - 1)
CALL readspc(inputpfad$, specname$(ispec%), 1, spec!(), maxnue&, nnue&, nuesa#, dnue#, ysa!, ysb!)
nuea# = nuesa#
nueb# = nuesa# + dnue# * CDBL(nnue&)
ya! = ysa!
yb! = ysb!

' menue
CLS
PRINT "x-zoom: 1/2 x-shift: 3/4 reset x: 5"
PRINT "y-zoom: 6/7 y-shift: 8/9 reset y: 0"
PRINT "next/ previous spectrum: a/s create reference spectrum: d"
PRINT "quit: q"
PRINT ""
INPUT "Continue with return", dummy$

' plot spectrum
CLS
CALL plotgrid
PRINT datum$, UTtime!, sunelev!, sunazi!
PRINT USING "#####.##  #####.##  ##.###^^^^  ##.###^^^^"; nuea#, nueb#, ya!, yb!
CALL plotspc(specmean!(), nnue&, nuesa#, dnue#, nuea#, nueb#, ya!, yb!, 5)
CALL plotspc(spec!(), nnue&, nuesa#, dnue#, nuea#, nueb#, ya!, yb!, 10)

nradius% = 10
istrefda% = 0
DO WHILE mychar$ <> "q"
    ' user choices
    mychar$ = INPUT$(1)
    SELECT CASE (mychar$)
        CASE ("a")
            ispec% = ispec% + 1
            IF ispec% > nspec% - 1 THEN ispec% = nspec% - 1
            ' read header + spectrum
            CALL readspchead(inputpfad$, specname$(ispec%), 1, datum$, UTtime!, sunelev!, sunazi!)
            CALL readspc(inputpfad$, specname$(ispec%), 1, spec!(), maxnue&, nnue&, nuesa#, dnue#, ysa!, ysb!)
            ' set reference spectrum to zero
            FOR inue& = 0 TO nnue&
                specmean!(inue&) = 0.0
            NEXT inue&
            istrefda% = 0
        CASE ("s")
            ispec% = ispec% - 1
            IF ispec% < 0 THEN ispec% = 0
            ' read header + spectrum
            CALL readspchead(inputpfad$, specname$(ispec%), 1, datum$, UTtime!, sunelev!, sunazi!)
            CALL readspc(inputpfad$, specname$(ispec%), 1, spec!(), maxnue&, nnue&, nuesa#, dnue#, ysa!, ysb!)
            ' set reference spectrum to zero
            FOR inue& = 0 TO nnue&
                specmean!(inue&) = 0.0
            NEXT inue&
            istrefda% = 0
        CASE ("d")
            PRINT "Constructing mean spectrum ..."
            ifirst% = ispec% - nradius%
            ilast% = ispec% + nradius%
            IF ifirst% < 0 THEN ifirst% = 0
            IF ilast% > nspec% - 1 THEN ilast% = nspec% - 1
            norm! = 1.0 / CSNG(ilast% - ifirst% + 1)
            FOR i% = ifirst% TO ilast%
                CALL readspc(inputpfad$, specname$(i%), 1, specwrk!(), maxnue&, nnue&, nuesa#, dnue#, ysa!, ysb!)
                FOR inue& = 0 TO nnue& - 1
                    specmean!(inue&) = specmean!(inue&) + specwrk!(inue&)
                NEXT inue&
            NEXT i%
            summean! = 0.0
            sumspec! = 0.0
            FOR inue& = 0 TO nnue& - 1
                specmean!(inue&) = specmean!(inue&) * norm!
                summean! = summean! + specmean!(inue&)
                sumspec! = sumspec! + spec!(inue&)
            NEXT inue&
            faktor! = sumspec! / summean!
            FOR inue& = 0 TO nnue& - 1
                specdiff!(inue&) = 10.0 * (spec!(inue&) - faktor! * specmean!(inue&))
            NEXT inue&

            istrefda% = 1
        CASE ("1")
            delta# = nueb# - nuea#
            nuea# = nuea# + 0.25# * delta#
            nueb# = nueb# - 0.25# * delta#
        CASE ("2")
            delta# = nueb# - nuea#
            nuea# = nuea# - 0.25# * delta#
            nueb# = nueb# + 0.25# * delta#
        CASE ("3")
            delta# = nueb# - nuea#
            nuea# = nuea# + 0.25# * delta#
            nueb# = nueb# + 0.25# * delta#
        CASE ("4")
            delta# = nueb# - nuea#
            nuea# = nuea# - 0.25# * delta#
            nueb# = nueb# - 0.25# * delta#
        CASE ("5")
            nuea# = nuesa#
            nueb# = nuesa# + dnue# * CDBL(nnue&)
        CASE ("6")
            delta! = yb! - ya!
            ya! = ya! + 0.25 * delta!
            yb! = yb! - 0.25 * delta!
        CASE ("7")
            delta! = yb! - ya!
            ya! = ya! - 0.25 * delta!
            yb! = yb! + 0.25 * delta!
        CASE ("8")
            delta! = yb! - ya!
            ya! = ya! + 0.25 * delta!
            yb! = yb! + 0.25 * delta!
        CASE ("9")
            delta! = yb! - ya!
            ya! = ya! - 0.25 * delta!
            yb! = yb! - 0.25 * delta!
        CASE ("0")
            ya! = ysa!
            yb! = ysb!
    END SELECT
    CLS
    CALL plotgrid
    PRINT datum$, UTtime!, sunelev!, sunazi!
    PRINT USING "#####.##  #####.##  ##.###^^^^  ##.###^^^^"; nuea#, nueb#, ya!, yb!
    CALL plotspc(specmean!(), nnue&, nuesa#, dnue#, nuea#, nueb#, ya!, yb!, 5)
    CALL plotspc(spec!(), nnue&, nuesa#, dnue#, nuea#, nueb#, ya!, yb!, 10)
    IF istrefda% = 1 THEN
        CALL plotspc(specdiff!(), nnue&, nuesa#, dnue#, nuea#, nueb#, ya!, yb!, 15)
    END IF
LOOP


END







SUB gonext (handle%)
    zeile$ = " "
    DO WHILE MID$(zeile$, 1, 1) <> "$"
        LINE INPUT #handle%, zeile$
    LOOP
END SUB



SUB plotgrid
    FOR i% = 1 TO 9
        x1% = 64 * i%
        FOR j% = 1 TO 9
            y1% = 48 * j%
            LINE (x1%, 0)-(x1%, 479), 5, , 64
            LINE (0, y1%)-(639, y1%), 5, , 64
        NEXT j%
    NEXT i%
END SUB



SUB plotspc (spec!(), nnue&, nuesa#, dnue#, nuea#, nueb#, ya!, yb!, farbe%)
    istart& = CLNG((nuea# - nuesa#) / dnue#) - 1
    istop& = CLNG((nueb# - nuesa#) / dnue#) + 1
    IF istart& < 0 THEN istart& = 0
    IF istart& > nnue& - 2 THEN istart& = nnue& - 2
    IF istop& < 0 THEN istop& = 0
    IF istop& > nnue& - 2 THEN istop& = nnue& - 2
    yoffset% = 479 - INT(479.0 * (-ya!) / (yb! - ya!))
    LINE (0, yoffset%)-(639, yoffset%), 1
    FOR i& = istart& TO istop&
        x1% = 639 - INT(639.0 * (nuesa# + dnue# * CDBL(i&) - nuea#) / (nueb# - nuea#))
        x2% = 640 - INT(639.0 * (nuesa# + dnue# * CDBL(i& + 1) - nuea#) / (nueb# - nuea#))
        y1% = 479 - INT(479.0 * (spec!(i&) - ya!) / (yb! - ya!))
        y2% = 479 - INT(479.0 * (spec!(i& + 1) - ya!) / (yb! - ya!))
        LINE (x1%, y1%)-(x2%, y2%), farbe%
    NEXT i&
END SUB



SUB readspc (inputpfad$, specname$, handle%, spec!(), maxnue&, nnue&, nuesa#, dnue#, ysa!, ysb!)
    DIM char1 AS STRING * 1
    FOR inue& = 0 TO maxnue& - 1
        spec!(inue&) = 0.0
    NEXT inue&
    OPEN inputpfad$ + specname$ FOR BINARY AS #handle%
    ifound% = 0
    DO WHILE ifound% < 6
        GET #handle%, , char1
        IF char1 = "$" THEN ifound% = ifound% + 1
    LOOP
    GET #handle%, , char1
    GET #handle%, , char1
    GET #handle%, , nuesa#
    GET #handle%, , dnue#
    GET #handle%, , nnue&
    GET #handle%, , spec!(0)
    ysa! = spec!(0)
    ysb! = spec!(0)
    FOR inue& = 1 TO nnue& - 1
        GET #handle%, , spec!(inue&)
        IF spec!(inue&) < ysa! THEN ysa! = spec!(inue&)
        IF spec!(inue&) > ysb! THEN ysb! = spec!(inue&)
    NEXT inue&
    CLOSE #handle%
END SUB



SUB readspchead (inputpfad$, specname$, handle%, datum$, UTtime!, sunelev!, sunazi!)
    OPEN inputpfad$ + specname$ FOR INPUT AS #handle%
    CALL gonext(handle%)
    LINE INPUT #handle%, dummy$
    INPUT #handle%, datum$
    INPUT #handle%, UTtime!
    INPUT #handle%, sunelev!
    INPUT #handle%, sunazi!
    CLOSE #handle%
END SUB


