SCREEN 12

eindatei$ = "specfit-viewer2.inp"

' read input file
OPEN eindatei$ FOR INPUT AS #1
CALL gonext(1)
LINE INPUT #1, inputpfad$
LINE INPUT #1, dateiname$
INPUT #1, lengthbinname%
INPUT #1, kindspc%
CLOSE #1

PRINT inputpfad$
PRINT dateiname$
PRINT lengthbinname%
PRINT kindspc%
INPUT "Continue with return", dummy$

' read header
CALL readspchead(inputpfad$, dateiname$, 1, lengthbinname%, kindspc%, maxspec&, nspec&, nnue&, firstnue#, dnue#)
lastnue# = firstnue# + CDBL(nnue& - 1) * dnue#
PRINT "maxspec: "; maxspec&
PRINT "nspec: "; nspec&
PRINT "nnue: "; nnue&
IF kindspc% = 1 THEN
    PRINT "firstnue: "; firstnue#
    PRINT "dnue: "; dnue#
ELSE
    PRINT "firstnue: not available, old spc format"
    PRINT "dnue: not available, old spc format"
END IF
INPUT "Continue with return", dummy$

' allocate spectra
DIM specmess!(0 TO nspec& - 1, 0 TO nnue& - 1), speccalc!(0 TO nspec& - 1, 0 TO nnue& - 1)
DIM specname$(0 TO nspec& - 1), ymax!(0 TO nspec& - 1)
PRINT "Reading all spectra ..."
CALL readallspc(inputpfad$, dateiname$, 1, lengthbinname%, kindspc%, specmess!(), speccalc!(), specname$(), ymax!(), nspec&, nnue&)
FOR i& = 0 TO nspec& - 1
    PRINT specname$(i&), ymax!(i&)
NEXT i&
INPUT "... done! Continue with return", dummy$

' menue
CLS
PRINT "y-zoom: 1/2 y-shift: 3/4 zoom res:5/6 reset: 7"
PRINT "quit: q"
PRINT ""
INPUT "Continue with return", dummy$

' plot spectrum
CLS
ispec& = 0
ya! = 0.0
yb! = ymax!(ispec&)
reszoom! = 1.0

CALL plotgrid
PRINT specname$(0)
PRINT USING "##.####  ##.###^^^^  ##.###^^^^"; reszoom!, ya!, yb!
CALL plotfit(specmess!(), speccalc!(), nnue&, ispec&, ya!, yb!, reszoom!, 10, 5, 3, 1)

DO WHILE mychar$ <> "q"
    ' user choices
    mychar$ = INPUT$(1)
    SELECT CASE (mychar$)
        CASE ("a")
            ispec& = ispec& + 1
            IF ispec& > nspec& - 1 THEN ispec& = nspec& - 1
        CASE ("s")
            ispec& = ispec& - 1
            IF ispec& < 0 THEN ispec& = 0
        CASE ("1")
            delta! = yb! - ya!
            ya! = ya! + 0.25 * delta!
            yb! = yb! - 0.25 * delta!
        CASE ("2")
            delta! = yb! - ya!
            ya! = ya! - 0.25 * delta!
            yb! = yb! + 0.25 * delta!
        CASE ("3")
            delta! = yb! - ya!
            ya! = ya! + 0.25 * delta!
            yb! = yb! + 0.25 * delta!
        CASE ("4")
            delta! = yb! - ya!
            ya! = ya! - 0.25 * delta!
            yb! = yb! - 0.25 * delta!
        CASE ("5")
            reszoom! = 2.0 * reszoom!
        CASE ("6")
            reszoom! = 0.5 * reszoom!
            IF reszoom! < 1.0 THEN reszoom! = 1.0
        CASE ("7")
            ya! = 0.0!
            yb! = ymax!(ispec&)
    END SELECT
    CLS
    CALL plotgrid
    PRINT specname$(ispec&)
    PRINT USING "##.####  ##.###^^^^  ##.###^^^^"; reszoom!, ya!, yb!
    IF kindspc% = 1 THEN PRINT USING "#####.##  #####.##"; firstnue#, lastnue#
    CALL plotfit(specmess!(), speccalc!(), nnue&, ispec&, ya!, yb!, reszoom!, 10, 5, 3, 1)
LOOP

END







SUB gonext (handle%)
    zeile$ = " "
    DO WHILE MID$(zeile$, 1, 1) <> "$"
        LINE INPUT #handle%, zeile$
    LOOP
END SUB



SUB plotgrid
    FOR i% = 1 TO 9
        x1% = 64 * i%
        FOR j% = 1 TO 9
            y1% = 48 * j%
            LINE (x1%, 0)-(x1%, 479), 5, , 64
            LINE (0, y1%)-(639, y1%), 5, , 64
        NEXT j%
    NEXT i%
END SUB



SUB plotfit (specmess!(), speccalc!(), nnue&, ispec&, ya!, yb!, reszoom!, farbea%, farbeb%, farbec%, farbed%)
    FOR i& = 0 TO nnue& - 2
        x1% = 639 - INT(639.0 * CSNG(i&) / CSNG(nnue& - 1))
        x2% = 639 - INT(639.0 * CSNG(i& + 1) / CSNG(nnue& - 1))
        y1a% = 479 - INT(479.0 * (specmess!(ispec&, i&) - ya!) / (yb! - ya!))
        y2a% = 479 - INT(479.0 * (specmess!(ispec&, i& + 1) - ya!) / (yb! - ya!))
        y1b% = 479 - INT(479.0 * (speccalc!(ispec&, i&) - ya!) / (yb! - ya!))
        y2b% = 479 - INT(479.0 * (speccalc!(ispec&, i& + 1) - ya!) / (yb! - ya!))
        diff1! = (specmess!(ispec&, i&) - speccalc!(ispec&, i&))
        diff2! = (specmess!(ispec&, i& + 1) - speccalc!(ispec&, i& + 1))
        y1c% = 240 - INT(479.0 * reszoom! * diff1! / (yb! - ya!))
        y2c% = 240 - INT(479.0 * reszoom! * diff2! / (yb! - ya!))
        yoffset! = 479 - INT(479.0 * (-ya!) / (yb! - ya!))

        LINE (0, yoffset!)-(639, yoffset!), farbed%
        LINE (x1%, y1a%)-(x2%, y2a%), farbea%
        LINE (x1%, y1b%)-(x2%, y2b%), farbeb%
        LINE (x1%, y1c%)-(x2%, y2c%), farbec%
    NEXT i&
END SUB



SUB readallspc (inputpfad$, dateiname$, handle%, lengthbinname%, kindspc%, specmess!(), speccalc!(), specname$(), ymax!(), nspec&, nnue&)
    OPEN inputpfad$ + dateiname$ FOR BINARY AS #handle%
    GET #handle%, , ndum&
    GET #handle%, , ndum&
    IF kindspc% = 1 THEN
        GET #handle%, , firstnue#
        GET #handle%, , dnue#
    END IF
    FOR ispec& = 0 TO nspec& - 1
        actname$ = ""
        FOR ichar% = 1 TO lengthbinname%
            GET #handle%, , char$1
            actname$ = actname$ + char$1
        NEXT ichar%
        specname$(ispec&) = actname$
        y! = -9.99E6
        FOR inue& = 0 TO nnue& - 1
            GET #handle%, , specmess!(ispec&, inue&)
            IF specmess!(ispec&, inue&) > y! THEN y! = specmess!(ispec&, inue&)
        NEXT inue&
        ymax!(ispec&) = y!
        FOR inue& = 0 TO nnue& - 1
            GET #handle%, , speccalc!(ispec&, inue&)
        NEXT inue&
    NEXT ispec&
    CLOSE #handle%
END SUB



SUB readspchead (inputpfad$, dateiname$, handle%, lengthbinname%, kindspc%, maxspec&, nspec&, nnue&, firstnue#, dnue#)
    OPEN inputpfad$ + dateiname$ FOR BINARY AS #handle%
    GET #handle%, , maxspec& '4 bytes
    GET #handle%, , nnue& ' 4 bytes
    IF kindspc% = 1 THEN
        GET #handle%, , firstnue# ' 8 bytes
        GET #handle%, , dnue# ' 8 bytes
    ELSE
        firstnue# = 0.0D0
        dnue# = 0.0D0
    END IF
    nbytes& = LOF(handle%)
    CLOSE #handle%
    IF kindspec% = 1 THEN
        nspec& = (nbytes& - 24&) / (CLNG(lengthbinname%) + 2& * 4& * nnue&)
    ELSE
        nspec& = (nbytes& - 8&) / (CLNG(lengthbinname%) + 2& * 4& * nnue&)
    END IF
END SUB


