#!/bin/bash
# Compile the PROFFAST retrieval code for Linux.
#
# Requirements:  gfortran-9
# Creator:       Lena Feld, Friedrich Klappenbach

# Set Compiler Options
COMPILER="gfortran-9"
COMPILER_OPTIONS="-nocpp -O3 -o"
INSTALL_FOLDER=$(pwd)

# Replace Windows specific line in source code
str_win='character(len=1),parameter\s::\spathstr\s=\s"\\"'
str_lin='character(len=1),parameter::pathstr="/"'

echo "adapting source code ..."
for file in source/*/*90;
do
	sed -i 's#'${str_win}'#'${str_lin}'#' $file
done

# Compile the source code
echo "compiling preprocess ..."
cd ${INSTALL_FOLDER}/source/preprocess/
${COMPILER} ${COMPILER_OPTIONS} ../../preprocess/preprocess4 glob_prepro4.F90 glob_OPUSparms.F90 preprocess4.F90

echo 'compiling pcxs ...'
cd ${INSTALL_FOLDER}/source/pcxs
${COMPILER} ${COMPILER_OPTIONS} ../../pcxs20 globvar20.f90 globlin20.f90 globlev20.f90 pcxs20.f90

echo 'compiling invers ...'
cd ${INSTALL_FOLDER}/source/invers
${COMPILER} ${COMPILER_OPTIONS} ../../invers20 globinv20.f90 invers20.f90

echo 'done.'

