#!/bin/bash
#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# Bash Script:   install_proffast_linux.sh
# Project:       COCCON-PROCEEDS, FRM4GHG, and S5P-MPC funded by ESA
# Created by:    Friedrich Klappenbach, Technical University of Munich (TUM), ge79wul@mytum.de
#-------------------------------------------------------------------------------------------------#
# This script installs the proffast 2 retrieval code under Linux.
# It compiles the required Linux-programs.
# Requirements:
# 	fortran compiler (e.g. fortran-11)
# if not available use:
# 	apt-get update
# 	apt-get upgrade
# 	apt-get install wget
# 	apt-get install unzip
# 	apt-get install gfortran
#-------------------------------------------------------------------------------------------------#
# Date:  2020/10/20
# Coder: Klappenbach, Friedrich <ge79wul@mytum.de>, adapted by Lena Feld
#-------------------------------------------------------------------------------------------------#
#=================================================================================================#


#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# Set Compiler Options
COMPILER="gfortran-11"
COMPILER_OPTIONS="-nocpp -O3 -o"
INSTALL_FOLDER=$(pwd)

#-------------------------------------------------------------------------------------------------#
# Replace Windows specific line in source code
str_win='character(len=1),parameter\s::\spathstr\s=\s"\\"'
str_lin='character(len=1),parameter::pathstr="/"'

echo "adapting source code ..."
for file in source/*/*90;
do
	sed -i 's#'${str_win}'#'${str_lin}'#' $file
done


#-------------------------------------------------------------------------------------------------#
# Compile the sourcecode:
echo "compiling preprocess ..."
cd ${INSTALL_FOLDER}/source/preprocess/
${COMPILER} ${COMPILER_OPTIONS} ../../preprocess/preprocess5 glob_prepro5.F90 glob_OPUSparms.F90 preprocess5.F90

echo 'compiling inverse...'
cd ${INSTALL_FOLDER}/source/invers
${COMPILER} ${COMPILER_OPTIONS} ../../invers20 globinv20.f90 invers20.f90

echo 'compiling pcxs...'
cd ${INSTALL_FOLDER}/source/pcxs
${COMPILER} ${COMPILER_OPTIONS} ../../pcxs20 globvar20.f90 globlin20.f90 globlev20.f90 pcxs20.f90
echo 'done.'

