#!/bin/bash
#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# Bash Script:   install_proffast_linux.sh
# Project:       COCCON-PROCEEDS, FRM4GHG, and S5P-MPC funded by ESA
# Created by:    Friedrich Klappenbach, Technical University of Munich (TUM), ge79wul@mytum.de
#-------------------------------------------------------------------------------------------------#
# This script installs the proffast 2 retrieval code under Linux.
# It compiles the required Linux-programs.
# Requirements:
# 	fortran compiler (e.g. fortran-11)
# if not available use:
# 	apt-get update
# 	apt-get upgrade
# 	apt-get install wget
# 	apt-get install unzip
# 	apt-get install gfortran
#-------------------------------------------------------------------------------------------------#
# Date:  2020/10/20
# Coder: Klappenbach, Friedrich <ge79wul@mytum.de>, adapted by Lena Feld
#-------------------------------------------------------------------------------------------------#
#=================================================================================================#


#=================================================================================================#
#-------------------------------------------------------------------------------------------------#
# Set Compiler Options
COMPILER="gfortran"
COMPILER_OPTIONS="-nocpp -O3 -o"
INSTALL_FOLDER=$(pwd)

#-------------------------------------------------------------------------------------------------#
# Replace Windows specific line in source code
str_lin='character(len=1),parameter :: pathstr = "/"'
str_win='character(len=1),parameter :: pathstr = "\\"'

echo "adapting source code ..."
for file in source/*/*90;
do
#	sed -i 's#'${str_win}'#'${str_lin}'#' $file
        sed -i 's|'"${str_win}|${str_lin}"'|' $file
done


#-------------------------------------------------------------------------------------------------#
# Compile the sourcecode:
echo "compiling preprocess ..."
cd ${INSTALL_FOLDER}/source/preprocess/
${COMPILER} ${COMPILER_OPTIONS} ../../preprocess/preprocess62 glob_prepro62.F90 glob_OPUSparms62.F90 preprocess62.F90

echo 'compiling invers...'
cd ${INSTALL_FOLDER}/source/invers
${COMPILER} ${COMPILER_OPTIONS} ../../invers26 globinv26.f90 invers26.f90

echo 'compiling pcxs...'
cd ${INSTALL_FOLDER}/source/pcxs
${COMPILER} ${COMPILER_OPTIONS} ../../pcxs24 globvar24.f90 globlin24.f90 globlev24.f90 pcxs24.f90


#-------------------------------------------------------------------------------------------------#
# Restoring source files to original:
echo "restoring files ..."
cd ${INSTALL_FOLDER}
for file in source/*/*90;

do
#      sed -i 's#'${str_lin}'#'${str_win}'#' $file
       sed -i 's|'"${str_lin}|${str_win}"'|' $file

done

echo 'done.'

